package ru.yandex.direct.core.entity.moderation.repository.sending;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.banner.type.additionalhrefs.BannerAdditionalHrefsRepository;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.dbschema.ppc.enums.PerfCreativesCreativeType;
import ru.yandex.direct.dbschema.ppc.enums.PhrasesAdgroupType;

@Repository
public class VideoBannerModerationRepositoryImpl extends BannerWithCreativesModerationRepository {

    @Autowired
    public VideoBannerModerationRepositoryImpl(BannerAdditionalHrefsRepository bannerAdditionalHrefsRepository,
                                               ModerationOperationModeProvider moderationOperationModeProvider) {
        super(bannerAdditionalHrefsRepository, moderationOperationModeProvider);
    }

    @Override
    protected List<PerfCreativesCreativeType> getCreativeTypes() {
        return List.of(PerfCreativesCreativeType.video_addition, PerfCreativesCreativeType.bannerstorage);
    }

    @Override
    protected BannersBannerType getBannerType() {
        return BannersBannerType.cpm_banner;
    }

    @Override
    protected List<PhrasesAdgroupType> getPhrasesAdgroupTypes() {
        return List.of(PhrasesAdgroupType.cpm_video);
    }
}
