package ru.yandex.direct.core.entity.moderation.service;

import java.util.stream.Stream;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ModerationObjectType {
    AUDIO_CREATIVE("audio_creative"),
    GEO_PIN_CREATIVE("geo_pin_creative"),
    YNDX_FRONTPAGE_CREATIVE("cpm_yndx_frontpage"),
    FIXCPM_YNDX_FRONTPAGE_CREATIVE("fixcpm_yndx_frontpage"),
    CONTENT_PROMOTION_VIDEO("content_promotion_video"),
    CONTENT_PROMOTION_COLLECTION("content_promotion_collection"),
    CONTENT_PROMOTION_SERVICE("content_promotion_service"),
    CPM_VIDEO("cpm_video"),
    //Отправляем с типом cpm_video, хотя форматы данных и отличаются, но в целом проверка в модеарации одинаковая (так было быстрее)
    IN_BANNER("cpm_video"),
    //Отправляем с типом cpm_video, так как с точки зрения модерации эти типы идентичные
    CPC_VIDEO("cpm_video"),
    TURBOLANDINGS("turbolink"),
    DISPLAYHREFS("display_href_sm"),
    SITELINKS_SET("sitelinks_set_sm"),
    IMAGES("image_sm"),
    BANNER_LOGOS("asset_icon"),
    BANNER_BUTTONS("asset_button_url"),
    BANNER_VCARD("asset_vcard"),
    BANNER_VIDEO_ADDITION("asset_video"),
    BANNER_MULTICARD("multicard"),
    AD_IMAGE("image_ad_sm"),
    CANVAS("canvas_sm"),
    HTML5("html5_sm"),
    BANNERSTORAGE_CREATIVES("smart_banner"),
    INTERNAL_BANNER("internal_banner"),
    TEXT_AD("text_sm"),
    CALLOUT("callout_sm"),
    PROMO_EXTENSION("promo_extension"), //промоакции
    ADGROUP("adgroup"),
    MOBILE_CONTENT("text_sm"),
    MOBILE_CONTENT_ICON("mobile_icon"),
    DYNAMIC("text_sm"),
    CAMPAIGN("campaign_sm"),
    UNKNOWN("unknown"), //For test purpose
        ;
    private String value;

    @JsonValue
    public String getValue() {
        return value;
    }

    ModerationObjectType(String value) {
        this.value = value;
    }

    /**
     * Определение enum по значению value.
     * Если совпадений не найдено, то возвращается null
     */
    @JsonCreator
    public static ModerationObjectType getEnumByValue(String value) {
        return Stream.of(ModerationObjectType.values())
                .filter(val -> val.value.equals(value))
                .findFirst()
                .orElse(null);
    }

}
