package ru.yandex.direct.core.entity.moderation.service;

import java.util.stream.Stream;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ModerationServiceNames {
    DIRECT_SERVICE("direct");
    private String value;

    @JsonValue
    public String getValue() {
        return value;
    }

    ModerationServiceNames(String value) {
        this.value = value;
    }

    @JsonCreator
    public static ModerationServiceNames getEnumByValue(String value) {
        return Stream.of(ModerationServiceNames.values())
                .filter(val -> val.value.equals(value))
                .findFirst()
                .orElse(null);
    }

}
