package ru.yandex.direct.core.entity.moderation.service.contentpromotion.subtype;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithModerationInfo;
import ru.yandex.direct.core.entity.contentpromotion.model.ContentPromotionContentType;
import ru.yandex.direct.core.entity.moderation.model.BannerLink;
import ru.yandex.direct.core.entity.moderation.model.contentpromotion.ContentPromotionBannerRequestData;
import ru.yandex.direct.core.entity.moderation.model.contentpromotion.ContentPromotionCollectionBannerRequestData;
import ru.yandex.direct.libs.collections.model.serpdata.CollectionSerpData;

import static java.util.Collections.singletonList;

@Component
@ParametersAreNonnullByDefault
public class ContentPromotionCollectionModerationTypeSupport implements ContentPromotionModerationTypeSupport {

    @Override
    public ContentPromotionContentType getContentPromotionType() {
        return ContentPromotionContentType.COLLECTION;
    }

    @Override
    public ContentPromotionBannerRequestData buildModerationData(BannerWithModerationInfo banner) {
        ContentPromotionCollectionBannerRequestData data = new ContentPromotionCollectionBannerRequestData();

        data.setLogin(banner.getLogin());

        CollectionSerpData collectionSerpData = CollectionSerpData.fromJson(banner.getContentPromotionMetadata());
        data.setContentUrl(collectionSerpData.getUrl());

        data.setCreativePreviewUrl(banner.getContentPromotionPreviewUrl());

        String visitUrl = banner.getContentPromotionVisitUrl();
        data.setLinks(singletonList(
                new BannerLink()
                        .setHref(visitUrl)));

        data.setCreativeId(banner.getContentPromotionId());

        return data;
    }
}
