package ru.yandex.direct.core.entity.moderation.service.contentpromotion.subtype;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.BannerWithModerationInfo;
import ru.yandex.direct.core.entity.contentpromotion.model.ContentPromotionContentType;
import ru.yandex.direct.core.entity.moderation.model.BannerModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.contentpromotion.ContentPromotionBannerRequestData;

import static ru.yandex.direct.utils.CommonUtils.nvl;

@ParametersAreNonnullByDefault
interface ContentPromotionModerationTypeSupport {

    ContentPromotionContentType getContentPromotionType();

    default BannerModerationMeta buildModerationMeta(BannerWithModerationInfo banner) {
        BannerModerationMeta meta = new BannerModerationMeta();

        meta.setBannerId(banner.getId());
        meta.setAdGroupId(banner.getAdGroupId());
        meta.setCampaignId(banner.getCampaignId());
        meta.setClientId(banner.getClientId());
        meta.setUid(banner.getUid());
        meta.setVersionId(nvl(banner.getVersion(), 0L) + 1);

        return meta;
    }

    ContentPromotionBannerRequestData buildModerationData(BannerWithModerationInfo banner);
}
