package ru.yandex.direct.core.entity.moderation.service.contentpromotion.subtype;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithModerationInfo;
import ru.yandex.direct.core.entity.contentpromotion.model.ContentPromotionContentType;
import ru.yandex.direct.core.entity.moderation.model.BannerModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.contentpromotion.ContentPromotionBannerRequestData;

/**
 * Диспетчер, помогающий сопоставить тип продвигаемого контента с обработчиками.
 *
 * @see ContentPromotionModerationTypeSupport
 */
@Component
@ParametersAreNonnullByDefault
public class ContentPromotionModerationTypeSupportFacade {

    private final Map<ContentPromotionContentType, ContentPromotionModerationTypeSupport> typeSupportByContentPromotionType;

    @Autowired
    public ContentPromotionModerationTypeSupportFacade(List<ContentPromotionModerationTypeSupport> typeSupports) {
        this.typeSupportByContentPromotionType = ImmutableMap.copyOf(
                Maps.uniqueIndex(typeSupports, ContentPromotionModerationTypeSupport::getContentPromotionType));
    }

    public BannerModerationMeta buildModerationMeta(BannerWithModerationInfo banner) {
        return typeSupportByContentPromotionType.get(banner.getContentPromotionType()).buildModerationMeta(banner);
    }

    public ContentPromotionBannerRequestData buildModerationData(BannerWithModerationInfo banner) {
        return typeSupportByContentPromotionType.get(banner.getContentPromotionType()).buildModerationData(banner);
    }
}
