package ru.yandex.direct.core.entity.moderation.service.receiving;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.moderation.model.asset.BannerAssetModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.receiving.BannerButtonModerationReceivingRepository;
import ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations.BannerButtonOperations;
import ru.yandex.direct.core.entity.moderation.service.receiving.processor.response_parser.BannerAssetResponseParser;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;

@Service
@Scope(SCOPE_PROTOTYPE)
public class BannerButtonModerationReceivingService extends BaseModerationReceivingService<BannerAssetModerationResponse, Long> {
    private static final Logger logger = LoggerFactory.getLogger(BannerButtonModerationReceivingService.class);

    @Autowired
    protected BannerButtonModerationReceivingService(DslContextProvider ppcDslContextProvider,
                                                     BannerButtonModerationReceivingRepository bannerLogoModerationReceivingRepository,
                                                     BannerAssetResponseParser bannerAssetResponseParser,
                                                     BannerButtonOperations bannerLogoOperations,
                                                     PpcPropertiesSupport ppcPropertiesSupport
    ) {
        super(ppcDslContextProvider,
                bannerLogoModerationReceivingRepository, bannerAssetResponseParser, bannerLogoOperations,
                ppcPropertiesSupport
        );
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected String getName() {
        return "banner-button";
    }
}
