package ru.yandex.direct.core.entity.moderation.service.receiving

import org.slf4j.Logger
import org.slf4j.LoggerFactory
import org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE
import org.springframework.context.annotation.Scope
import org.springframework.stereotype.Service
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.core.entity.moderation.model.asset.BannerAssetModerationResponse
import ru.yandex.direct.core.entity.moderation.repository.receiving.BannerMulticardModerationReceivingRepository
import ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations.BannerMulticardOperations
import ru.yandex.direct.core.entity.moderation.service.receiving.processor.response_parser.BannerAssetResponseParser
import ru.yandex.direct.dbutil.wrapper.DslContextProvider

@Service
@Scope(SCOPE_PROTOTYPE)
class BannerMulticardModerationReceivingService(
    dslContextProvider: DslContextProvider,
    bannerMulticardModerationReceivingRepository: BannerMulticardModerationReceivingRepository,
    bannerAssetResponseParser: BannerAssetResponseParser,
    bannerMulticardOperations: BannerMulticardOperations,
    ppcPropertiesSupport: PpcPropertiesSupport
) : BaseModerationReceivingService<BannerAssetModerationResponse, Long>(
    dslContextProvider,
    bannerMulticardModerationReceivingRepository,
    bannerAssetResponseParser,
    bannerMulticardOperations,
    ppcPropertiesSupport
) {
    private val logger: Logger = LoggerFactory.getLogger(BannerMulticardModerationReceivingService::class.java)

    override fun getLogger(): Logger = logger

    override fun getName(): String = "banner-multicard"
}
