package ru.yandex.direct.core.entity.moderation.service.receiving;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.moderation.model.callout.CalloutModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.receiving.CalloutModerationReceivingRepository;
import ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations.CalloutOperations;
import ru.yandex.direct.core.entity.moderation.service.receiving.processor.response_parser.CalloutResponseParser;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;

@Service
@Scope(SCOPE_PROTOTYPE)
public class CalloutModerationReceivingService extends BaseModerationReceivingService<CalloutModerationResponse, Long> {
    private static final Logger logger = LoggerFactory.getLogger(CalloutModerationReceivingService.class);

    @Autowired
    protected CalloutModerationReceivingService(
            DslContextProvider dslContextProvider,
            CalloutModerationReceivingRepository calloutModerationReceivingRepository,
            CalloutResponseParser calloutResponseParser,
            CalloutOperations calloutOperations,
            PpcPropertiesSupport ppcPropertiesSupport
    ) {
        super(dslContextProvider, calloutModerationReceivingRepository, calloutResponseParser,
                calloutOperations, ppcPropertiesSupport);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected String getName() {
        return "callout";
    }
}
