package ru.yandex.direct.core.entity.moderation.service.receiving;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.moderation.model.displayhrefs.DisplayHrefsModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.receiving.DisplayHrefsModerationReceivingRepository;
import ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations.DisplayhrefsOperations;
import ru.yandex.direct.core.entity.moderation.service.receiving.processor.response_parser.DisplayhrefsResponseParser;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;

@Service
@Scope(SCOPE_PROTOTYPE)
public class DisplayHrefsModerationReceivingService extends BaseModerationReceivingService<DisplayHrefsModerationResponse, Long> {
    private static final Logger logger = LoggerFactory.getLogger(DisplayHrefsModerationReceivingService.class);

    @Autowired
    protected DisplayHrefsModerationReceivingService(DslContextProvider ppcDslContextProvider,
                                                     DisplayHrefsModerationReceivingRepository displayHrefsModerationReceivingRepository,
                                                     DisplayhrefsOperations displayhrefsOperations,
                                                     DisplayhrefsResponseParser displayhrefsResponseParser,
                                                     PpcPropertiesSupport ppcPropertiesSupport
    ) {
        super(ppcDslContextProvider,
                displayHrefsModerationReceivingRepository, displayhrefsResponseParser, displayhrefsOperations,
                ppcPropertiesSupport
        );
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected String getName() {
        return "displayhrefs";
    }
}
