package ru.yandex.direct.core.entity.moderation.service.receiving;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.moderation.model.image.ImageModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.receiving.ImageModerationReceivingRepository;
import ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations.ImageOperations;
import ru.yandex.direct.core.entity.moderation.service.receiving.processor.response_parser.ImageResponseParser;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;

@Service
@Scope(SCOPE_PROTOTYPE)
public class ImageModerationReceivingService extends BaseModerationReceivingService<ImageModerationResponse, Long> {
    private static final Logger logger = LoggerFactory.getLogger(ImageModerationReceivingService.class);

    @Autowired
    protected ImageModerationReceivingService(DslContextProvider ppcDslContextProvider,
                                              ImageModerationReceivingRepository imageModerationReceivingRepository,
                                              ImageResponseParser imageResponseParser, ImageOperations imageOperations,
                                              PpcPropertiesSupport ppcPropertiesSupport
    ) {
        super(ppcDslContextProvider,
                imageModerationReceivingRepository, imageResponseParser, imageOperations, ppcPropertiesSupport);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected String getName() {
        return "image";
    }
}
