package ru.yandex.direct.core.entity.moderation.service.receiving;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.banner.repository.BannerRelationsRepository;
import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.receiving.BannersModerationReceivingRepository;
import ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations.InternalBannerOperations;
import ru.yandex.direct.core.entity.moderation.service.receiving.processor.response_parser.BannerResponseParser;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;

@Service
@Scope(SCOPE_PROTOTYPE)
@ParametersAreNonnullByDefault
public class InternalBannerModerationReceivingService extends BannerModerationResponsesReceivingService {
    @Autowired
    public InternalBannerModerationReceivingService(
            BannerRelationsRepository bannerRelationsRepository,
            AdGroupRepository adGroupRepository,
            DslContextProvider dslContextProvider,
            BannersModerationReceivingRepository bannersModerationReceivingRepository,
            InternalBannerOperations bannerOperations,
            BannerResponseParser bannerResponseParser,
            BannerChangesValidator bannerChangesValidator,
            PpcPropertiesSupport ppcPropertiesSupport
    ) {
        super(bannerRelationsRepository, adGroupRepository, dslContextProvider,
                bannersModerationReceivingRepository, bannerOperations, bannerResponseParser,
                bannerChangesValidator, ppcPropertiesSupport);
    }

    @Override
    protected void postProcessResponses(int shard, List<BannerModerationResponse> responses) {
        // nothing
    }
}
