package ru.yandex.direct.core.entity.moderation.service.receiving;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.db.PpcProperty;
import ru.yandex.direct.common.db.PpcPropertyNames;

@Component
public class MinusRegionsToBannerFlagsService {
    private final PpcPropertiesSupport ppcPropertiesSupport;

    private final PpcProperty<Boolean> saveEnabled;
    private final PpcProperty<Set<Long>> saveEnabledForCampaignIds;

    @Autowired
    public MinusRegionsToBannerFlagsService(PpcPropertiesSupport ppcPropertiesSupport) {
        this.ppcPropertiesSupport = ppcPropertiesSupport;

        this.saveEnabled = ppcPropertiesSupport.get(
                PpcPropertyNames.SAVE_MINUS_REGIONS_AS_BANNER_FLAGS, Duration.ofMinutes(1));
        this.saveEnabledForCampaignIds = ppcPropertiesSupport.get(
                PpcPropertyNames.SAVE_MINUS_REGIONS_AS_BANNER_FLAGS_ENABLED_CAMPAIGN_IDS, Duration.ofMinutes(1));
    }

    public boolean isMinusRegionsToBannerFlagsSaveEnabled(Long campaignId) {
        if (saveEnabled.getOrDefault(false)) {
            return true;
        }

        if (saveEnabledForCampaignIds.getOrDefault(Collections.emptySet()).contains(campaignId)) {
            return true;
        }

        return false;
    }
}
