package ru.yandex.direct.core.entity.moderation.service.receiving;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.moderation.model.mobilecontenticon.MobileContentIconModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.receiving.MobileContentIconModerationReceivingRepository;
import ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations.MobileContentIconOperations;
import ru.yandex.direct.core.entity.moderation.service.receiving.processor.response_parser.MobileContentIconResponseParser;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;

@Service
@Scope(SCOPE_PROTOTYPE)
public class MobileContentIconModerationReceivingService
        extends BaseModerationReceivingService<MobileContentIconModerationResponse, Long> {
    private static final Logger logger = LoggerFactory.getLogger(BaseModerationReceivingService.class);

    @Autowired
    protected MobileContentIconModerationReceivingService(
            DslContextProvider dslContextProvider,
            MobileContentIconModerationReceivingRepository mobileContentIconModerationReceivingRepository,
            MobileContentIconResponseParser mobileContentIconResponseParser,
            MobileContentIconOperations mobileContentIconOperations,
            PpcPropertiesSupport ppcPropertiesSupport
    ) {
        super(dslContextProvider, mobileContentIconModerationReceivingRepository, mobileContentIconResponseParser,
                mobileContentIconOperations, ppcPropertiesSupport);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected String getName() {
        return "mobile_content_icon";
    }
}
