package ru.yandex.direct.core.entity.moderation.service.receiving

import org.slf4j.Logger
import org.slf4j.LoggerFactory
import org.springframework.beans.factory.config.ConfigurableBeanFactory
import org.springframework.context.annotation.Scope
import org.springframework.stereotype.Service
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.core.entity.moderation.model.promoextension.PromoExtensionModerationResponse
import ru.yandex.direct.core.entity.moderation.repository.receiving.PromoExtensionModerationReceivingRepository
import ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations.PromoExtensionOperations
import ru.yandex.direct.core.entity.moderation.service.receiving.processor.response_parser.PromoExtensionResponseParser
import ru.yandex.direct.dbutil.wrapper.DslContextProvider

@Service
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
class PromoExtensionModerationReceivingService(
    dslContextProvider: DslContextProvider,
    promoExtensionModerationReceivingRepository: PromoExtensionModerationReceivingRepository,
    promoExtensionResponseParser: PromoExtensionResponseParser,
    promoExtensionOperations: PromoExtensionOperations,
    ppcPropertiesSupport: PpcPropertiesSupport
) : BaseModerationReceivingService<PromoExtensionModerationResponse, Long>(
    dslContextProvider,
    promoExtensionModerationReceivingRepository,
    promoExtensionResponseParser,
    promoExtensionOperations,
    ppcPropertiesSupport
) {
    private val logger: Logger = LoggerFactory.getLogger(PromoExtensionModerationReceivingService::class.java)

    override fun getLogger(): Logger = logger

    override fun getName(): String = "promo-extension"
}

