package ru.yandex.direct.core.entity.moderation.service.receiving;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.moderation.model.sitelinks.SitelinksModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.receiving.SitelinksModerationReceivingRepository;
import ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations.SitelinksOperations;
import ru.yandex.direct.core.entity.moderation.service.receiving.processor.response_parser.SitelinksResponseParser;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;

@Service
@Scope(SCOPE_PROTOTYPE)
public class SitelinksModerationReceivingService extends BaseModerationReceivingService<SitelinksModerationResponse, Long> {
    private static final Logger logger = LoggerFactory.getLogger(SitelinksModerationReceivingService.class);

    @Autowired
    protected SitelinksModerationReceivingService(DslContextProvider ppcDslContextProvider,
                                                  SitelinksModerationReceivingRepository sitelinksModerationReceivingRepository,
                                                  SitelinksResponseParser sitelinksResponseParser,
                                                  SitelinksOperations sitelinksOperations,
                                                  PpcPropertiesSupport ppcPropertiesSupport) {

        super(ppcDslContextProvider,
                sitelinksModerationReceivingRepository, sitelinksResponseParser, sitelinksOperations, ppcPropertiesSupport
        );
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected String getName() {
        return "sitelinks";
    }
}
