package ru.yandex.direct.core.entity.moderation.service.receiving;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.moderation.model.turbolandings.TurbolandingsModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.receiving.TurboModerationReceivingRepository;
import ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations.TurbolandingOperations;
import ru.yandex.direct.core.entity.moderation.service.receiving.processor.response_parser.TurbolandingResponseParser;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;

@Service
@Scope(SCOPE_PROTOTYPE)
public class TurbolandingModerationReceivingService extends BaseModerationReceivingService<TurbolandingsModerationResponse, Long> {

    private static final Logger logger = LoggerFactory.getLogger(TurbolandingModerationReceivingService.class);

    @Autowired
    protected TurbolandingModerationReceivingService(DslContextProvider ppcDslContextProvider,
                                                     TurboModerationReceivingRepository turboModerationReceivingRepository,
                                                     TurbolandingResponseParser turbolandingResponseParser,
                                                     TurbolandingOperations turbolandingOperations,
                                                     PpcPropertiesSupport ppcPropertiesSupport
    ) {
        super(ppcDslContextProvider,
                turboModerationReceivingRepository, turbolandingResponseParser, turbolandingOperations, ppcPropertiesSupport
        );
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected String getName() {
        return "turbolandings";
    }
}
