package ru.yandex.direct.core.entity.moderation.service.receiving;

import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.moderation.model.asset.BannerVideoAdditionModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.receiving.VideoAdditionModerationReceivingRepository;
import ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations.VideoAdditionOperations;
import ru.yandex.direct.core.entity.moderation.service.receiving.processor.response_parser.BannerVideoAdditionResponseParser;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;

@Service
@Scope(SCOPE_PROTOTYPE)
public class VideoAdditionModerationReceivingService
        extends BaseModerationReceivingService<BannerVideoAdditionModerationResponse, Pair<Long, Long>> {
    private static final Logger logger = LoggerFactory.getLogger(VideoAdditionModerationReceivingService.class);

    @Autowired
    protected VideoAdditionModerationReceivingService(DslContextProvider ppcDslContextProvider,
                                                      VideoAdditionModerationReceivingRepository moderationReceivingRepository,
                                                      BannerVideoAdditionResponseParser bannerAssetResponseParser,
                                                      VideoAdditionOperations operations,
                                                      PpcPropertiesSupport ppcPropertiesSupport
    ) {
        super(ppcDslContextProvider,
                moderationReceivingRepository, bannerAssetResponseParser, operations, ppcPropertiesSupport
        );
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected String getName() {
        return "banner-video-addition";
    }
}
