package ru.yandex.direct.core.entity.moderation.service.receiving.dyn_disclaimers;

import java.math.BigInteger;
import java.util.Objects;

import static ru.yandex.direct.utils.HashingUtils.getMd5HalfHashUtf8;

public class DisclaimerUpdateRequest {
    private final long clientId;
    private final long bid;
    private final String disclaimerText;
    private final BigInteger hash;

    public DisclaimerUpdateRequest(long clientId, long bid, String disclaimerText) {
        this.clientId = clientId;
        this.bid = bid;
        this.disclaimerText = disclaimerText;
        this.hash = getMd5HalfHashUtf8(disclaimerText);
    }

    public long getClientId() {
        return clientId;
    }

    public long getBid() {
        return bid;
    }

    public String getDisclaimerText() {
        return disclaimerText;
    }

    public boolean isDisclaimerEmpty() {
        return disclaimerText == null || disclaimerText.isBlank();
    }

    public BigInteger getHash() {
        return hash;
    }

    public String uniqKey() {
        return String.join("/", getClientId() + "", getHash() + "");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DisclaimerUpdateRequest that = (DisclaimerUpdateRequest) o;
        return clientId == that.clientId &&
                bid == that.bid &&
                Objects.equals(disclaimerText, that.disclaimerText);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientId, bid, disclaimerText);
    }

    @Override
    public String toString() {
        return "DisclaimerUpdateRequest{" +
                "clientId=" + clientId +
                ", bid=" + bid +
                ", disclaimerText='" + disclaimerText + '\'' +
                '}';
    }
}
