package ru.yandex.direct.core.entity.moderation.service.receiving.operations.ad_image;

import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.model.ModerationDecision;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdate;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.BulkBannersOp;
import ru.yandex.direct.dbschema.ppc.enums.ImagesStatusmoderate;
import ru.yandex.direct.dbschema.ppc.tables.records.ImagesRecord;

import static ru.yandex.direct.dbschema.ppc.tables.Images.IMAGES;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class UpdateImageStatusModerateOp extends BulkBannersOp {

    @Override
    public void consume(BulkUpdateHolder bulkUpdateHolder, BannerModerationResponse response) {
        BulkUpdate.RowChanges<ImagesRecord> rowChanges =
                bulkUpdateHolder.get(IMAGES.BID).forId(response.getMeta().getBannerId());

        if (response.getResult().getVerdict() == ModerationDecision.Yes) {
            rowChanges.set(IMAGES.STATUS_MODERATE, ImagesStatusmoderate.Yes);
        } else if (response.getResult().getVerdict() == ModerationDecision.No) {
            rowChanges.set(IMAGES.STATUS_MODERATE, ImagesStatusmoderate.No);
        }
    }

}
