package ru.yandex.direct.core.entity.moderation.service.receiving.operations.ad_image;

import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.BulkBannersOp;

import static ru.yandex.direct.dbschema.ppc.tables.Images.IMAGES;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class UpdateImageTextOp extends BulkBannersOp {

    @Override
    public void consume(BulkUpdateHolder bulkUpdateHolder, BannerModerationResponse response) {
        bulkUpdateHolder.get(IMAGES.BID).forId(response.getMeta().getBannerId())
                .set(IMAGES.IMAGE_TEXT, response.getResult().getAdvertisedItem());
    }
}
