package ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners;

import java.util.ArrayList;
import java.util.List;

import org.jooq.Configuration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.repository.BannersToFillLanguageQueueRepository;
import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class AddBannersToLanguageFillQueue implements ModerationResponseProcessingOp<BannerModerationResponse> {
    private final BannersToFillLanguageQueueRepository bannersToFillLanguageQueueRepository;
    private final List<Long> bids = new ArrayList<>();

    @Autowired
    public AddBannersToLanguageFillQueue(BannersToFillLanguageQueueRepository bannersToFillLanguageQueueRepository) {
        this.bannersToFillLanguageQueueRepository = bannersToFillLanguageQueueRepository;
    }

    @Override
    public void consume(BulkUpdateHolder bulkUpdateHolder, BannerModerationResponse response) {
        bids.add(response.getMeta().getBannerId());
    }

    @Override
    public void flush(Configuration configuration, BulkUpdateHolder bulkUpdateHolder) {
        bannersToFillLanguageQueueRepository.addItems(configuration.dsl(), bids);
    }
}
