package ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners;

import org.jooq.Configuration;
import org.jooq.Record;
import org.jooq.TableField;

import ru.yandex.direct.core.entity.moderation.model.ModerationDecision;
import ru.yandex.direct.core.entity.moderation.model.asset.BaseBannerAssetModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdate;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusbssynced;
import ru.yandex.direct.dbschema.ppc.enums.PhrasesStatusbssynced;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.PHRASES;

public abstract class BaseSetBannerAssetStatusModerateOp<H extends Record, T extends Enum<T>, R extends BaseBannerAssetModerationResponse<?>>
        implements ModerationResponseProcessingOp<R> {
    private final TableField<H, Long> keyField;
    private final TableField<H, T> statusModerateField;
    private final T yesStatusModerate;
    private final T noStatusModerate;

    protected BaseSetBannerAssetStatusModerateOp(TableField<H, Long> keyField, TableField<H, T> statusModerateField,
                                                 T yesStatusModerate, T noStatusModerate) {
        this.keyField = keyField;
        this.statusModerateField = statusModerateField;
        this.yesStatusModerate = yesStatusModerate;
        this.noStatusModerate = noStatusModerate;
    }

    @Override
    public void consume(BulkUpdateHolder bulkUpdateHolder, R response) {
        bulkUpdateHolder.get(PHRASES.PID).forId(response.getMeta().getAdGroupId())
                .set(PHRASES.STATUS_BS_SYNCED, PhrasesStatusbssynced.No);

        bulkUpdateHolder.get(BANNERS.BID).forId(response.getMeta().getBannerId())
                .set(BANNERS.STATUS_BS_SYNCED, BannersStatusbssynced.No);

        buildRowChanges(bulkUpdateHolder, response);
    }

    protected BulkUpdate.RowChanges<H> buildRowChanges(
            BulkUpdateHolder bulkUpdateHolder, R response
    ) {
        BulkUpdate.RowChanges<H> rowChanges =
                bulkUpdateHolder.get(keyField).forId(response.getMeta().getBannerId());
        if (response.getResult().getVerdict() == ModerationDecision.Yes) {
            rowChanges.set(statusModerateField, yesStatusModerate);
        } else if (response.getResult().getVerdict() == ModerationDecision.No) {
            rowChanges.set(statusModerateField, noStatusModerate);
        }
        return rowChanges;
    }

    @Override
    public void flush(Configuration configuration, BulkUpdateHolder bulkUpdateHolder) {
        // do nothing because of this is bulk operation
    }
}
