package ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.callout.CalloutModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.common.InsertOrUpdateModerationReasonsOp;
import ru.yandex.direct.core.entity.moderationreason.model.ModerationReasonObjectType;
import ru.yandex.direct.core.entity.moderationreason.repository.ModerationReasonRepository;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class CalloutInsertOrUpdateModerationReasonsOp
        extends InsertOrUpdateModerationReasonsOp<CalloutModerationResponse> {

    @Autowired
    public CalloutInsertOrUpdateModerationReasonsOp(ModerationReasonRepository moderationReasonRepository) {
        super(moderationReasonRepository, ModerationReasonObjectType.CALLOUT, true);
    }

    @Override
    protected ReasonsInfo parseResponse(CalloutModerationResponse response) {
        return new ReasonsInfo(
                response.getMeta().getCalloutId(),
                0L,
                response.getMeta().getClientId(),
                response.getResult().getReasonsWithDetails());
    }
}
