package ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.jooq.Configuration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.bs.resync.queue.model.BsResyncItem;
import ru.yandex.direct.core.entity.bs.resync.queue.service.BsResyncService;
import ru.yandex.direct.core.entity.moderation.model.callout.CalloutModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;

import static ru.yandex.direct.core.entity.bs.resync.queue.model.BsResyncPriority.UPDATE_BANNER_WITH_ADDITIONS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_ADDITIONS;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class CalloutLazyBsResyncBannersOperation implements ModerationResponseProcessingOp<CalloutModerationResponse> {

    private final BsResyncService bsResyncService;

    private final Set<Long> calloutIds = new HashSet<>();

    @Autowired
    public CalloutLazyBsResyncBannersOperation(BsResyncService bsResyncService) {
        this.bsResyncService = bsResyncService;
    }

    @Override
    public void consume(BulkUpdateHolder bulkUpdateHolder, CalloutModerationResponse response) {
        calloutIds.add(response.getMeta().getCalloutId());
    }

    @Override
    public void flush(Configuration configuration, BulkUpdateHolder bulkUpdateHolder) {
        List<BsResyncItem> bannersToResync = configuration.dsl()
                .selectDistinct(BANNERS.BID, BANNERS.PID, BANNERS.CID)
                .from(BANNERS_ADDITIONS)
                .join(BANNERS).on(BANNERS.BID.eq(BANNERS_ADDITIONS.BID))
                .where(BANNERS_ADDITIONS.ADDITIONS_ITEM_ID.in(calloutIds))
                .fetch(record -> new BsResyncItem(UPDATE_BANNER_WITH_ADDITIONS,
                        record.get(BANNERS.CID), record.get(BANNERS.BID), record.get(BANNERS.PID)));

        bsResyncService.addObjectsToResync(bannersToResync);
    }
}
