package ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.google.common.collect.Iterables;
import org.jooq.Configuration;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder;

import static ru.yandex.direct.dbschema.ppc.Tables.CATALOGIA_BANNERS_RUBRICS;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class CatalogiaIdsSavingOp implements BannersResponseProcessingOp<BannerModerationResponse> {
    private final Map<Long, String> catalogiaIds;

    public CatalogiaIdsSavingOp() {
        catalogiaIds = new HashMap<>();
    }

    @Override
    public void consume(BulkUpdateHolder bulkUpdateHolder, BannerModerationResponse response) {
        List<Long> catalogiaIds = response.getResult().getCatalogiaIds();

        if (catalogiaIds != null && !catalogiaIds.isEmpty()) {
            String stringWithIds =
                    catalogiaIds.stream().distinct()
                            .map(e -> Long.toString(e))
                            .collect(Collectors.joining(","));

            this.catalogiaIds.put(response.getMeta().getBannerId(), stringWithIds);
        }
    }


    @Override
    public void flush(Configuration configuration, BulkUpdateHolder bulkUpdateHolder) {
        for (var partition : Iterables.partition(catalogiaIds.entrySet(), 5000)) {
            var insertStep = configuration.dsl().insertInto(CATALOGIA_BANNERS_RUBRICS)
                    .columns(CATALOGIA_BANNERS_RUBRICS.BID, CATALOGIA_BANNERS_RUBRICS.CATEGORIES_BS);

            for (var entry : partition) {
                insertStep = insertStep.values(entry.getKey(), entry.getValue());
            }

            insertStep.onDuplicateKeyIgnore().execute();
            //TODO sleep?
        }
    }
}
