package ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import one.util.streamex.EntryStream;
import org.jooq.Configuration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.type.creative.BannerCreativeRepository;
import ru.yandex.direct.core.entity.banner.type.image.BannerImageRepository;
import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.ModerationRepository;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder;

import static ru.yandex.direct.dbschema.ppc.enums.ModReasonsType.canvas;
import static ru.yandex.direct.dbschema.ppc.enums.ModReasonsType.image_ad;
import static ru.yandex.direct.dbschema.ppc.enums.ModReasonsType.video_addition;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
/*
    Раньше  баннеры с креативами отправлялись в модеарцию как два объекта, а теперь их соединили.
    Удаляем причины которые могли остаться на этих дополнительных объектах, которые больше не отправляем.
 */
public class DeleteCreativeReasonsOp implements BannersResponseProcessingOp<BannerModerationResponse> {
    private final BannerCreativeRepository bannerCreativeRepository;
    private final BannerImageRepository imageRepository;

    private final ModerationRepository moderationRepository;
    private final List<Long> bids = new ArrayList<>();

    @Autowired
    public DeleteCreativeReasonsOp(BannerCreativeRepository bannerCreativeRepository,
                                   BannerImageRepository imageRepository,
                                   ModerationRepository moderationRepository) {
        this.bannerCreativeRepository = bannerCreativeRepository;
        this.imageRepository = imageRepository;
        this.moderationRepository = moderationRepository;
    }

    @Override
    public void consume(BulkUpdateHolder bulkUpdateHolder, BannerModerationResponse response) {
        bids.add(response.getMeta().getBannerId());
    }

    @Override
    public void flush(Configuration configuration, BulkUpdateHolder bulkUpdateHolder) {
        List<Long> creativeIds = bannerCreativeRepository.getBannerPerformanceCreativeIds(configuration.dsl(), bids);

        moderationRepository.deleteModReasonBatch(configuration.dsl(), List.of(canvas, video_addition), creativeIds)
                .execute();

        List<Long> bannerImagesIds =
                EntryStream.of(imageRepository.getImageIdsByBannerIds(configuration.dsl(), bids))
                        .values()
                        .flatMap(List::stream)
                        .collect(Collectors.toList());

        moderationRepository.deleteModReasonBatch(configuration.dsl(), List.of(image_ad), bannerImagesIds)
                .execute();
    }
}
