package ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import one.util.streamex.EntryStream;
import org.jooq.Configuration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.InternalBanner;
import ru.yandex.direct.core.entity.banner.model.InternalModerationInfo;
import ru.yandex.direct.core.entity.banner.repository.BannerTypedRepository;
import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.common.BaseBannerInsertOrUpdateModerationReasonsOp;
import ru.yandex.direct.core.entity.moderationreason.model.ModerationReasonObjectType;
import ru.yandex.direct.core.entity.moderationreason.model.ModerationReasonStatusModerate;
import ru.yandex.direct.core.entity.moderationreason.repository.ModerationReasonRepository;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusshow;
import ru.yandex.direct.multitype.repository.filter.Filter;

import static ru.yandex.direct.common.util.RepositoryUtils.booleanToLong;
import static ru.yandex.direct.core.entity.banner.type.system.BannerWithSystemFieldsMappings.statusShowToDb;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_INTERNAL;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;
import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.multipleConditionFilter;
import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.whereEqFilter;
import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.whereInFilter;
import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.whereJsonFieldEqFilter;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class InternalBannersInsertOrUpdateModerationReasonsOp extends BaseBannerInsertOrUpdateModerationReasonsOp<BannerModerationResponse> {

    private final BannerTypedRepository bannerTypedRepository;

    @Autowired
    public InternalBannersInsertOrUpdateModerationReasonsOp(ModerationReasonRepository moderationReasonRepository,
                                                            BannerTypedRepository bannerTypedRepository) {
        super(moderationReasonRepository, ModerationReasonObjectType.BANNER, true);
        this.bannerTypedRepository = bannerTypedRepository;
    }

    @Override
    public void flush(Configuration configuration, BulkUpdateHolder bulkUpdateHolder) {
        super.flush(configuration, bulkUpdateHolder);
        enableRelevantBanners(configuration, bulkUpdateHolder);
    }

    /**
     * При положительном вердикте модерации если внутренний баннер выключен и statusShowAfterModeration=true,
     * то включаем баннер
     * смотри: https://st.yandex-team.ru/DIRECT-144085
     */
    private void enableRelevantBanners(Configuration configuration, BulkUpdateHolder bulkUpdateHolder) {
        Set<Long> moderatedBannerIds = EntryStream.of(getModReasons())
                .filterValues(moderationReason ->
                        ModerationReasonStatusModerate.YES == moderationReason.getStatusModerate())
                .keys()
                .toSet();
        List<InternalBanner> bannersForEnabling = bannerTypedRepository.getSafely(configuration.dsl(),
                bannersFilterForEnabling(moderatedBannerIds), InternalBanner.class);

        List<Long> bannerIdsForEnabling = mapList(bannersForEnabling, InternalBanner::getId);
        for (var bid : bannerIdsForEnabling) {
            bulkUpdateHolder.get(BANNERS.BID)
                    .forId(bid)
                    .set(BANNERS.STATUS_SHOW, BannersStatusshow.Yes);
        }
    }

    public static Filter bannersFilterForEnabling(Collection<Long> bannerIds) {
        return multipleConditionFilter(
                whereInFilter(BANNERS.BID, bannerIds),
                whereJsonFieldEqFilter(BANNERS_INTERNAL.MODERATION_INFO,
                        InternalModerationInfo.STATUS_SHOW_AFTER_MODERATION.name(),
                        Boolean.class, true),
                whereEqFilter(BANNERS_INTERNAL.IS_STOPPED_BY_URL_MONITORING, booleanToLong(false)),
                whereEqFilter(BANNERS.STATUS_SHOW, statusShowToDb(false))
        );
    }

}
