package ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners;

import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusbssynced;
import ru.yandex.direct.dbschema.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.direct.dbschema.ppc.tables.Banners;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.PHRASES;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class ResetStatusBsSyncedOp extends BulkBannersOp {

    @Override
    public void consume(BulkUpdateHolder bulkUpdateHolder, BannerModerationResponse response) {
        bulkUpdateHolder.get(BANNERS.BID)
                .forId(response.getMeta().getBannerId())
                .set(Banners.BANNERS.STATUS_BS_SYNCED, BannersStatusbssynced.No);

         /*
             phrases.statusBsSynced здесь обновляется только чтобы отправить потенциально новый баннер в БК вместе
             с целым условием
             подробности см. в DIRECT-33440, после DIRECT-30677 можно будет выпилить
         */

        bulkUpdateHolder.get(PHRASES.PID)
                .forId(response.getMeta().getAdGroupId())
                .set(PHRASES.STATUS_BS_SYNCED, PhrasesStatusbssynced.No);
    }

}
