package ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners;

import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerFlags;
import ru.yandex.direct.core.entity.moderation.model.asset.BannerAssetModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdate;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder;
import ru.yandex.direct.dbschema.ppc.enums.BannerMulticardSetsStatusmoderate;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerMulticardSetsRecord;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_MULTICARD_SETS;


@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class SetBannerMulticardStatusModerateAndFlagsOp
        extends BaseSetBannerAssetStatusModerateOp<BannerMulticardSetsRecord, BannerMulticardSetsStatusmoderate,
                                                   BannerAssetModerationResponse> {

    @Autowired
    public SetBannerMulticardStatusModerateAndFlagsOp() {
        super(BANNER_MULTICARD_SETS.BID, BANNER_MULTICARD_SETS.STATUS_MODERATE,
                BannerMulticardSetsStatusmoderate.Yes, BannerMulticardSetsStatusmoderate.No);
    }

    @Override
    protected BulkUpdate.RowChanges<BannerMulticardSetsRecord> buildRowChanges(
            BulkUpdateHolder bulkUpdateHolder, BannerAssetModerationResponse response
    ) {
        var rowChanges = super.buildRowChanges(bulkUpdateHolder, response);

        var flags = response.getResult().getFlags();
        BannerFlags bannerFlags = new BannerFlags();
        if (!MapUtils.isEmpty(flags)) {
            bannerFlags.withFlagsFromModeration(flags);
        }
        rowChanges.set(BANNER_MULTICARD_SETS.FLAGS, BannerFlags.toSource(bannerFlags));
        return rowChanges;
    }
}
