package ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners;

import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.model.ModerationDecision;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdate;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder;
import ru.yandex.direct.dbschema.ppc.enums.BannerTurbolandingsStatusmoderate;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerTurbolandingsRecord;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_TURBOLANDINGS;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class SetTurbolandingStatusModerateFromBannerOp extends BulkBannersOp {

    @Override
    public void consume(BulkUpdateHolder bulkUpdateHolder, BannerModerationResponse response) {
        BulkUpdate.RowChanges<BannerTurbolandingsRecord> rowChanges =
                bulkUpdateHolder.get(BANNER_TURBOLANDINGS.BID).forId(response.getMeta().getBannerId());

        if (response.getResult().getVerdict() == ModerationDecision.Yes) {
            rowChanges.set(BANNER_TURBOLANDINGS.STATUS_MODERATE, BannerTurbolandingsStatusmoderate.Yes);
        } else if (response.getResult().getVerdict() == ModerationDecision.No) {
            rowChanges.set(BANNER_TURBOLANDINGS.STATUS_MODERATE, BannerTurbolandingsStatusmoderate.No);
        }
    }
}
