package ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners;

import java.util.ArrayList;
import java.util.List;

import com.google.common.collect.Lists;
import org.jooq.Configuration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder;
import ru.yandex.direct.core.entity.moderation.service.receiving.dyn_disclaimers.DisclaimerUpdateRequest;
import ru.yandex.direct.core.entity.moderation.service.receiving.dyn_disclaimers.DisclaimersUpdatingService;

import static ru.yandex.direct.utils.CommonUtils.nvl;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class UpdateBannerDynDisclaimer implements BannersResponseProcessingOp<BannerModerationResponse> {
    private final DisclaimersUpdatingService disclaimersUpdatingService;
    private final List<DisclaimerUpdateRequest> requests;

    @Autowired
    public UpdateBannerDynDisclaimer(DisclaimersUpdatingService disclaimersUpdatingService) {
        this.disclaimersUpdatingService = disclaimersUpdatingService;
        requests = new ArrayList<>();
    }

    @Override
    public void consume(BulkUpdateHolder bulkUpdateHolder, BannerModerationResponse response) {
        requests.add(new DisclaimerUpdateRequest(response.getMeta().getClientId(),
                response.getMeta().getBannerId(),
                nvl(response.getResult().getDynDisclaimer(), ""))
        );
    }

    @Override
    public void flush(Configuration configuration, BulkUpdateHolder bulkUpdateHolder) {
        for (var chunk : Lists.partition(requests, 500)) {
            disclaimersUpdatingService.update(configuration, chunk);
        }
    }
}
