package ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners;

import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.Language;
import ru.yandex.direct.core.entity.banner.type.language.BannerLanguageConverter;
import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder;

import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class UpdateBannerLanguageOp extends BulkBannersOp {
    @Override
    public void consume(BulkUpdateHolder bulkUpdateHolder, BannerModerationResponse response) {
        Language lang = BannerLanguageConverter
                .convertLanguage(response.getResult().getLang());

        if (lang == Language.UNKNOWN) {
            return;
        }

        bulkUpdateHolder.get(BANNERS.BID)
                .forId(response.getMeta().getBannerId())
                .set(BANNERS.LANGUAGE, Language.toSource(lang));
    }

}
