package ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners;

import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.model.ModerationDecision;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdate;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder;
import ru.yandex.direct.dbschema.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersPerformanceRecord;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_PERFORMANCE;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class UpdateBannerPerformanceStatusModerateOp extends BulkBannersOp {

    @Override
    public void consume(BulkUpdateHolder bulkUpdateHolder, BannerModerationResponse response) {
        BulkUpdate.RowChanges<BannersPerformanceRecord> rowChanges =
                bulkUpdateHolder.get(BANNERS_PERFORMANCE.BID).forId(response.getMeta().getBannerId());

        if (response.getResult().getVerdict() == ModerationDecision.Yes) {
            rowChanges.set(BANNERS_PERFORMANCE.STATUS_MODERATE, BannersPerformanceStatusmoderate.Yes);
        } else if (response.getResult().getVerdict() == ModerationDecision.No) {
            rowChanges.set(BANNERS_PERFORMANCE.STATUS_MODERATE, BannersPerformanceStatusmoderate.No);
        }

        rowChanges.set(BANNERS_PERFORMANCE.EXTRACTED_TEXT, response.getResult().getAdvertisedItem());
    }
}
