package ru.yandex.direct.core.entity.moderation.service.receiving.operations.bannerstorage;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.bannerstorage.BannerstorageCreativeModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.common.DeleteFromModReasonsOp;
import ru.yandex.direct.core.entity.moderationreason.repository.ModerationReasonRepository;
import ru.yandex.direct.dbschema.ppc.enums.ModReasonsType;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class BannerstorageCreativeDeleteFromModReasonsOp
        extends DeleteFromModReasonsOp<BannerstorageCreativeModerationResponse> {

    @Autowired
    public BannerstorageCreativeDeleteFromModReasonsOp(ModerationReasonRepository moderationReasonRepository) {
        super(moderationReasonRepository, ModReasonsType.perf_creative);
    }

    @Override
    protected Long getId(BannerstorageCreativeModerationResponse response) {
        return response.getMeta().getCreativeId();
    }
}
