package ru.yandex.direct.core.entity.moderation.service.receiving.operations.bannerstorage;

import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.bannerstorage.BannerstorageCreativeModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.common.BaseBannerInsertOrUpdateModerationReasonsOp;
import ru.yandex.direct.core.entity.moderationreason.model.ModerationReasonObjectType;
import ru.yandex.direct.core.entity.moderationreason.repository.ModerationReasonRepository;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class BannerstorageCreativeInsertOrUpdateModReasonsOp extends
        BaseBannerInsertOrUpdateModerationReasonsOp<BannerstorageCreativeModerationResponse> {
    public BannerstorageCreativeInsertOrUpdateModReasonsOp(ModerationReasonRepository moderationReasonRepository) {
        super(moderationReasonRepository, ModerationReasonObjectType.PERF_CREATIVE, false);
    }

    @Override
    protected ReasonsInfo parseResponse(BannerstorageCreativeModerationResponse response) {
        return new ReasonsInfo(
                response.getMeta().getCreativeId(),
                response.getMeta().getCampaignId(),
                response.getMeta().getClientId(),
                response.getResult().getReasonsWithDetails()
        );
    }
}
