package ru.yandex.direct.core.entity.moderation.service.receiving.operations.bannerstorage;

import java.util.ArrayList;
import java.util.List;

import org.jooq.Configuration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.bannerstorage.BannerstorageCreativeModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdate;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder;
import ru.yandex.direct.core.entity.moderation.repository.receiving.BannerstorageCreativesModerationReceivingRepository;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusbssynced;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class ResetBsSyncOnPerformanceBannersOp implements
        ModerationResponseProcessingOp<BannerstorageCreativeModerationResponse> {
    private final BannerstorageCreativesModerationReceivingRepository receivingRepository;

    private final List<Long> modifiedCreatives = new ArrayList<>();

    @Autowired
    public ResetBsSyncOnPerformanceBannersOp(BannerstorageCreativesModerationReceivingRepository receivingRepository) {
        this.receivingRepository = receivingRepository;
    }

    @Override
    public void consume(BulkUpdateHolder bulkUpdateHolder, BannerstorageCreativeModerationResponse response) {
        modifiedCreatives.add(response.getMeta().getCreativeId());
    }

    @Override
    public void flush(Configuration configuration, BulkUpdateHolder bulkUpdateHolder) {
        var bids = receivingRepository.getBannersLinkedToCreatives(configuration.dsl(), modifiedCreatives);
        BulkUpdate<BannersRecord, Long> updater = bulkUpdateHolder.get(BANNERS.BID);
        bids.forEach(bid -> updater.forId(bid).set(BANNERS.STATUS_BS_SYNCED, BannersStatusbssynced.No));
    }
}
