package ru.yandex.direct.core.entity.moderation.service.receiving.operations.bannerstorage;

import org.jooq.Configuration;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.ModerationDecision;
import ru.yandex.direct.core.entity.moderation.model.bannerstorage.BannerstorageCreativeModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.dbschema.ppc.enums.PerfCreativesStatusmoderate;

import static ru.yandex.direct.core.entity.moderation.repository.receiving.BannerstorageCreativesModerationReceivingRepository.BANNERSTORAGE_CREATIVE_MODERATED_BY_DIRECT_MARKER;
import static ru.yandex.direct.dbschema.ppc.Tables.PERF_CREATIVES;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class SetBannerstorageCreativeStatusModerateOp
        implements ModerationResponseProcessingOp<BannerstorageCreativeModerationResponse> {

    @Override
    public void consume(BulkUpdateHolder bulkUpdateHolder, BannerstorageCreativeModerationResponse response) {
        var changes = bulkUpdateHolder.get(PERF_CREATIVES.CREATIVE_ID).forId(response.getMeta().getCreativeId())
                .set(PERF_CREATIVES.ADDITIONAL_DATA, BANNERSTORAGE_CREATIVE_MODERATED_BY_DIRECT_MARKER);

        if (response.getResult().getVerdict() == ModerationDecision.Yes) {
            changes.set(PERF_CREATIVES.STATUS_MODERATE, PerfCreativesStatusmoderate.Yes);
        } else if (response.getResult().getVerdict() == ModerationDecision.No) {
            changes.set(PERF_CREATIVES.STATUS_MODERATE, PerfCreativesStatusmoderate.No);
        }
    }

    @Override
    public void flush(Configuration configuration, BulkUpdateHolder bulkUpdateHolder) {
        // do nothing because this is bulk operation
    }
}
