package ru.yandex.direct.core.entity.moderation.service.receiving.operations.common;

import ru.yandex.direct.core.entity.moderation.model.AbstractModerationResultResponse;
import ru.yandex.direct.core.entity.moderation.model.BaseBannerModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.ModerationResult;
import ru.yandex.direct.core.entity.moderationreason.model.ModerationReasonObjectType;
import ru.yandex.direct.core.entity.moderationreason.repository.ModerationReasonRepository;

public abstract class BaseBannerInsertOrUpdateModerationReasonsOp<T extends AbstractModerationResultResponse<?
        extends BaseBannerModerationMeta, ? extends ModerationResult>> extends InsertOrUpdateModerationReasonsOp<T> {

    public BaseBannerInsertOrUpdateModerationReasonsOp(ModerationReasonRepository moderationReasonRepository,
                                                       ModerationReasonObjectType moderationReasonObjectType,
                                                       boolean saveYesModReasons) {
        super(moderationReasonRepository, moderationReasonObjectType, saveYesModReasons);
    }

    protected ReasonsInfo parseResponse(T response) {
        return new ReasonsInfo(
                response.getMeta().getBannerId(),
                response.getMeta().getCampaignId(),
                response.getMeta().getClientId(),
                response.getResult().getReasonsWithDetails()
        );
    }
}
