package ru.yandex.direct.core.entity.moderation.service.receiving.operations.common;

import java.util.ArrayList;
import java.util.List;

import org.jooq.Configuration;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.moderation.model.AbstractModerationResultResponse;
import ru.yandex.direct.core.entity.moderation.model.BaseModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.ModerationDecision;
import ru.yandex.direct.core.entity.moderation.model.ModerationResult;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.core.entity.moderationreason.repository.ModerationReasonRepository;
import ru.yandex.direct.dbschema.ppc.enums.ModReasonsType;

public abstract class DeleteFromModReasonsOp<T extends AbstractModerationResultResponse<?
        extends BaseModerationMeta, ? extends ModerationResult>> implements ModerationResponseProcessingOp<T> {
    private final ModerationReasonRepository moderationReasonRepository;
    private final List<Long> yesIds;
    private final ModReasonsType modReasonsType;

    @Autowired
    public DeleteFromModReasonsOp(ModerationReasonRepository moderationReasonRepository,
                                  ModReasonsType modReasonsType) {
        this.moderationReasonRepository = moderationReasonRepository;
        this.modReasonsType = modReasonsType;
        this.yesIds = new ArrayList<>();
    }

    @Override
    public void consume(BulkUpdateHolder bulkUpdateHolder, T response) {
        if (response.getResult().getVerdict() == ModerationDecision.Yes) {
            yesIds.add(getId(response));
        }
    }

    @Override
    public void flush(Configuration configuration, BulkUpdateHolder bulkUpdateHolder) {
        moderationReasonRepository.deleteFromModReasons(configuration, yesIds, modReasonsType);
    }

    protected abstract Long getId(T response);
}
