package ru.yandex.direct.core.entity.moderation.service.receiving.operations.image;

import org.jooq.Configuration;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.ModerationDecision;
import ru.yandex.direct.core.entity.moderation.model.image.ImageModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.dbschema.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusbssynced;
import ru.yandex.direct.dbschema.ppc.enums.PhrasesStatusbssynced;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_IMAGES;
import static ru.yandex.direct.dbschema.ppc.Tables.PHRASES;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class SetImageStatusModerateOp implements ModerationResponseProcessingOp<ImageModerationResponse> {

    @Override
    public void consume(BulkUpdateHolder bulkUpdateHolder, ImageModerationResponse response) {
        var changes = bulkUpdateHolder.get(BANNER_IMAGES.BID).forId(response.getMeta().getBannerId());
        if (response.getResult().getVerdict() == ModerationDecision.Yes) {
            changes.set(BANNER_IMAGES.STATUS_MODERATE, BannerImagesStatusmoderate.Yes);
        } else if (response.getResult().getVerdict() == ModerationDecision.No) {
            changes.set(BANNER_IMAGES.STATUS_MODERATE, BannerImagesStatusmoderate.No);
        }

        bulkUpdateHolder.get(BANNERS.BID).forId(response.getMeta().getBannerId())
                .set(BANNERS.STATUS_BS_SYNCED, BannersStatusbssynced.No);

        bulkUpdateHolder.get(PHRASES.PID).forId(response.getMeta().getAdGroupId())
                .set(PHRASES.STATUS_BS_SYNCED, PhrasesStatusbssynced.No);
    }

    @Override
    public void flush(Configuration configuration, BulkUpdateHolder bulkUpdateHolder) {
        // do nothing because this is bulk operation
    }
}
