package ru.yandex.direct.core.entity.moderation.service.receiving.operations.mobilecontenticon;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.mobilecontenticon.MobileContentIconModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.common.InsertOrUpdateModerationReasonsOp;
import ru.yandex.direct.core.entity.moderationreason.model.ModerationReasonObjectType;
import ru.yandex.direct.core.entity.moderationreason.repository.ModerationReasonRepository;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class MobileContentIconInsertOrUpdateModerationReasonsOp
        extends InsertOrUpdateModerationReasonsOp<MobileContentIconModerationResponse> {
    @Autowired
    public MobileContentIconInsertOrUpdateModerationReasonsOp(ModerationReasonRepository moderationReasonRepository) {
        super(moderationReasonRepository, ModerationReasonObjectType.MOBILE_CONTENT, true);
    }

    @Override
    protected ReasonsInfo parseResponse(MobileContentIconModerationResponse response) {
        return new ReasonsInfo(
                response.getMeta().getMobileContentId(),
                0L,
                response.getMeta().getClientId(),
                response.getResult().getReasonsWithDetails());
    }
}
