package ru.yandex.direct.core.entity.moderation.service.receiving.operations.mobilecontenticon;

import org.jooq.Configuration;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.ModerationDecision;
import ru.yandex.direct.core.entity.moderation.model.mobilecontenticon.MobileContentIconModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.dbschema.ppc.enums.MobileContentStatusbssynced;
import ru.yandex.direct.dbschema.ppc.enums.MobileContentStatusiconmoderate;

import static ru.yandex.direct.dbschema.ppc.Tables.MOBILE_CONTENT;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class SetMobileContentIconStatusModerateAndBsSyncedOp
        implements ModerationResponseProcessingOp<MobileContentIconModerationResponse> {
    @Override
    public void consume(BulkUpdateHolder bulkUpdateHolder, MobileContentIconModerationResponse response) {
        var rowChanges = bulkUpdateHolder.get(MOBILE_CONTENT.MOBILE_CONTENT_ID)
                .forId(response.getMeta().getMobileContentId());

        if (response.getResult().getVerdict() == ModerationDecision.Yes) {
            rowChanges.set(MOBILE_CONTENT.STATUS_ICON_MODERATE, MobileContentStatusiconmoderate.Yes);
        } else if (response.getResult().getVerdict() == ModerationDecision.No) {
            rowChanges.set(MOBILE_CONTENT.STATUS_ICON_MODERATE, MobileContentStatusiconmoderate.No);
        }

        rowChanges.set(MOBILE_CONTENT.STATUS_BS_SYNCED, MobileContentStatusbssynced.No);
    }

    @Override
    public void flush(Configuration configuration, BulkUpdateHolder bulkUpdateHolder) {
    }
}
