package ru.yandex.direct.core.entity.moderation.service.receiving.operations.promoextension

import org.springframework.beans.factory.config.ConfigurableBeanFactory
import org.springframework.context.annotation.Scope
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.moderation.model.promoextension.PromoExtensionModerationResponse
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.common.DeleteFromModReasonsOp
import ru.yandex.direct.core.entity.moderationreason.repository.ModerationReasonRepository
import ru.yandex.direct.dbschema.ppc.enums.ModReasonsType

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
class PromoExtensionDeleteFromModReasonsOp(
    moderationReasonRepository: ModerationReasonRepository,
) : DeleteFromModReasonsOp<PromoExtensionModerationResponse>(
    moderationReasonRepository,
    ModReasonsType.promo_extension,
) {
    override fun getId(response: PromoExtensionModerationResponse) = response.meta!!.promoExtensionId
}
