package ru.yandex.direct.core.entity.moderation.service.receiving.operations.promoextension

import org.springframework.beans.factory.config.ConfigurableBeanFactory
import org.springframework.context.annotation.Scope
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.moderation.model.promoextension.PromoExtensionModerationResponse
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.common.InsertOrUpdateModerationReasonsOp
import ru.yandex.direct.core.entity.moderationreason.model.ModerationReasonObjectType
import ru.yandex.direct.core.entity.moderationreason.repository.ModerationReasonRepository

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
class PromoExtensionInsertOrUpdateModerationReasonOp(
    moderationReasonRepository: ModerationReasonRepository,
) : InsertOrUpdateModerationReasonsOp<PromoExtensionModerationResponse>(
    moderationReasonRepository,
    ModerationReasonObjectType.PROMO_EXTENSION,
    false,
) {
    override fun parseResponse(response: PromoExtensionModerationResponse) =
        ReasonsInfo(response.meta!!.promoExtensionId,
            0L,
            response.meta!!.clientId,
            response.result!!.reasonsWithDetails)
}
