package ru.yandex.direct.core.entity.moderation.service.receiving.operations.promoextension

import org.jooq.Configuration
import org.springframework.beans.factory.config.ConfigurableBeanFactory
import org.springframework.context.annotation.Scope
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.moderation.model.ModerationDecision
import ru.yandex.direct.core.entity.moderation.model.promoextension.PromoExtensionModerationResponse
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp
import ru.yandex.direct.dbschema.ppc.Tables.PROMOACTIONS
import ru.yandex.direct.dbschema.ppc.enums.PromoactionsStatusmoderate

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
class SetPromoExtensionStatusModerateOp : ModerationResponseProcessingOp<PromoExtensionModerationResponse> {
    override fun consume(bulkUpdateHolder: BulkUpdateHolder, response: PromoExtensionModerationResponse) {
        val changes = bulkUpdateHolder.get(PROMOACTIONS.ID).forId(response.meta!!.promoExtensionId)

        if (response.result!!.verdict == ModerationDecision.Yes) {
            changes.set(PROMOACTIONS.STATUS_MODERATE, PromoactionsStatusmoderate.Yes)
        } else if (response.result!!.verdict == ModerationDecision.No) {
            changes.set(PROMOACTIONS.STATUS_MODERATE, PromoactionsStatusmoderate.No)
        }
    }

    override fun flush(configuration: Configuration?, bulkUpdateHolder: BulkUpdateHolder?) {
        // do nothing because this is bulk operation
    }
}
