package ru.yandex.direct.core.entity.moderation.service.receiving.operations.sitelinks;

import java.util.ArrayList;
import java.util.List;

import org.jooq.Configuration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.ModerationDecision;
import ru.yandex.direct.core.entity.moderation.model.sitelinks.SitelinksModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.core.entity.sitelink.repository.SitelinkSetRepository;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusbssynced;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatussitelinksmoderate;
import ru.yandex.direct.dbschema.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.direct.dbschema.ppc.tables.Banners;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.PHRASES;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class SetSitelinksStatusModerateOp implements ModerationResponseProcessingOp<SitelinksModerationResponse> {
    private final SitelinkSetRepository sitelinkSetRepository;
    private final List<Long> bids = new ArrayList<>();

    @Autowired
    public SetSitelinksStatusModerateOp(SitelinkSetRepository sitelinkSetRepository) {
        this.sitelinkSetRepository = sitelinkSetRepository;
    }

    @Override
    public void consume(BulkUpdateHolder bulkUpdateHolder, SitelinksModerationResponse response) {
        var changes = bulkUpdateHolder.get(BANNERS.BID).forId(response.getMeta().getBannerId())
                .set(Banners.BANNERS.STATUS_BS_SYNCED, BannersStatusbssynced.No);

        if (response.getResult().getVerdict() == ModerationDecision.Yes) {
            changes.set(BANNERS.STATUS_SITELINKS_MODERATE, BannersStatussitelinksmoderate.Yes);
        } else if (response.getResult().getVerdict() == ModerationDecision.No) {
            changes.set(BANNERS.STATUS_SITELINKS_MODERATE, BannersStatussitelinksmoderate.No);
        }

        bids.add(response.getMeta().getBannerId());
    }

    @Override
    public void flush(Configuration configuration, BulkUpdateHolder bulkUpdateHolder) {
        // https://st.yandex-team.ru/DIRECT-119788
        // Надо скинуть статус синхронизаци с бк у некоторых групп
        var updater = bulkUpdateHolder.get(PHRASES.PID);
        sitelinkSetRepository.selectGroupsForResync(configuration, bids)
                .forEach(id -> updater.forId(id).set(PHRASES.STATUS_BS_SYNCED, PhrasesStatusbssynced.No));
    }
}
