package ru.yandex.direct.core.entity.moderation.service.receiving.operations.turbolandings;

import org.jooq.Configuration;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.ModerationDecision;
import ru.yandex.direct.core.entity.moderation.model.turbolandings.TurbolandingsModerationResponse;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.dbschema.ppc.enums.BannerTurbolandingsStatusmoderate;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusbssynced;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_TURBOLANDINGS;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class SetTurbolandingStatusModerateOp
        implements ModerationResponseProcessingOp<TurbolandingsModerationResponse> {

    @Override
    public void consume(BulkUpdateHolder bulkUpdateHolder, TurbolandingsModerationResponse response) {
        var changes = bulkUpdateHolder.get(BANNER_TURBOLANDINGS.BID).forId(response.getMeta().getBannerId());

        if (response.getResult().getVerdict() == ModerationDecision.Yes) {
            changes.set(BANNER_TURBOLANDINGS.STATUS_MODERATE, BannerTurbolandingsStatusmoderate.Yes);
        } else if (response.getResult().getVerdict() == ModerationDecision.No) {
            changes.set(BANNER_TURBOLANDINGS.STATUS_MODERATE, BannerTurbolandingsStatusmoderate.No);
        }

        bulkUpdateHolder.get(BANNERS.BID).forId(response.getMeta().getBannerId())
                .set(BANNERS.STATUS_BS_SYNCED, BannersStatusbssynced.No);
    }

    @Override
    public void flush(Configuration configuration, BulkUpdateHolder bulkUpdateHolder) {
        // do nothing because this is bulk operation
    }
}
