package ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations;

import java.util.List;

import com.google.common.collect.ImmutableList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ad_image.UpdateImageStatusModerateOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ad_image.UpdateImageTextOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.AddBannersToLanguageFillQueue;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.BannersInsertOrUpdateModerationReasonsOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.StopUnfamilyMCBannerOp;

@Component
public class AdImageOperations extends BannerOperations {

    private static final List<Class<? extends ModerationResponseProcessingOp<BannerModerationResponse>>> ADIMAGE_OPERATIONS =
            ImmutableList.<Class<? extends ModerationResponseProcessingOp<BannerModerationResponse>>>builder()
                    .addAll(BANNERS_OPERATIONS)
                    .add(UpdateImageTextOp.class)
                    .add(UpdateImageStatusModerateOp.class)
                    .add(AddBannersToLanguageFillQueue.class)
                    .add(BannersInsertOrUpdateModerationReasonsOp.class)
                    .add(StopUnfamilyMCBannerOp.class)
                    .build();

    @Autowired
    public AdImageOperations(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    public List<Class<? extends ModerationResponseProcessingOp<BannerModerationResponse>>> getOperationClasses() {
        return ADIMAGE_OPERATIONS;
    }

}
