package ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.asset.BannerAssetModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.BannerAssetUpdateApiDomainStatOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.BannerButtonDeleteFromModReasonsOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.BannerButtonInsertOrUpdateModerationReasonsOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.SetBannerButtonStatusModerateOp;

@Component
public class BannerButtonOperations extends BaseResponseOperationsChain<BannerAssetModerationResponse> {

    private static final List<Class<? extends ModerationResponseProcessingOp<BannerAssetModerationResponse>>>
            BANNER_BUTTON_OPERATIONS = List.of(
            SetBannerButtonStatusModerateOp.class,
            BannerButtonDeleteFromModReasonsOp.class,
            BannerButtonInsertOrUpdateModerationReasonsOp.class,
            BannerAssetUpdateApiDomainStatOp.class
    );

    @Autowired
    public BannerButtonOperations(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    public List<Class<? extends ModerationResponseProcessingOp<BannerAssetModerationResponse>>> getOperationClasses() {
        return BANNER_BUTTON_OPERATIONS;
    }
}
